//Directory for Windows user:
//cd %systemdrive%\Users\%username%\Downloads\Codes\04_Experiments\
//Directory for MacOS user:
//cd ~/Downloads/04_Experiments/

use "Source_datasets/master.dta", replace
sort id_regulation

save "Datasets/master.dta", replace

import delimited "Datasets/Measures.csv", clear
rename regulation id_regulation
sort id_regulation
save "Datasets/measures.dta", replace

use "Datasets/master.dta", replace

merge m:1 id_regulation using "Datasets/measures.dta"
drop if id_regulation > 38
drop if id_regulation ==0
drop _merge
save "Datasets/main.dta", replace

//Create a dataset with 38 regulations and frequency of mistakes.

collapse(mean) is_correct time length cyclomatic quantity potentialvolume operatordiversity level uniqueoperands uniquemoperators uniqueloperators uniqueroperators totaloperands totalmoperators totalloperators totalroperators, by(id_regulation)

//0. Descriptive Statistics
gen mistakes = 1-is_correct
sum mistakes, d

gen cyclomatic_n = cyclomatic/length
gen quantity_n = quantity/length
gen diversity_n = operatordiversity/length

// Table 4
quietly estpost tabstat length cyclomatic_n quantity_n level diversity_n, statistics (mean sd min p25 median p75 max)
esttab, cells("length(label(`:var lab length') fmt(%12.0fc)) cyclomatic_n(label(`:var lab cyclomatic') fmt(%12.2fc)) quantity_n(label(`:var lab quantity') fmt(%12.2fc)) diversity_n(label(`:var lab diversity') fmt(%12.2fc)) level(label(`:var lab level') fmt(%12.2fc))") ///
noobs nomtitle nonumber varlabels(`e(labels)') varwidth(20) tex
