//Directory for Windows user:
//cd %systemdrive%\Users\%username%\Downloads\Codes\04_Experiments\
//Directory for MacOS user:
//cd ~/Downloads/04_Experiments/

use "Datasets/main.dta", replace

//Convert time into number of seconds
rename time time2
generate time = 60*mm(time2)+ss(time2)
drop time2

sum time, d

drop if is_correct==0
drop if time >= 579

sum time, d

//1. Correlation of different measures with time, controlling for length.

quietly reg time length i.id_question i.user, robust 
estimates store regr1_1
quietly reg time length cyclomatic i.id_question i.user, robust 
estimates store regr1_2
quietly reg time length quantity i.id_question i.user, robust 
estimates store regr1_3
quietly reg time length potentialvolume i.id_question i.user, robust 
estimates store regr1_4
quietly reg time length operatordiversity i.id_question i.user, robust 
estimates store regr1_5
quietly reg time length level i.id_question i.user, robust 
estimates store regr1_6

//Table 6
estout regr1_1 regr1_2 regr1_3 regr1_4 regr1_5 regr1_6, cells(b(star fmt(3)) t(par fmt(2))) stats(r2_a, fmt(3) labels(R2_a))  style(tex) keep(length cyclomatic quantity potentialvolume operatordiversity level) starlevels(* 0.10 ** 0.05 *** 0.01) ///
legend label collabels(none)  type


// ONLINE APPENDIX. Correlation of different measures with time, controlling for length. No round fixed effects.

quietly reg time length i.user, robust 
estimates store regr2_1
quietly reg time length cyclomatic i.user, robust 
estimates store regr2_2
quietly reg time length quantity i.user, robust 
estimates store regr2_3
quietly reg time length potentialvolume i.user, robust 
estimates store regr2_4
quietly reg time length operatordiversity i.user, robust 
estimates store regr2_5
quietly reg time length level i.user, robust 
estimates store regr2_6

// Table OA.15
estout regr2_1 regr2_2 regr2_3 regr2_4 regr2_5 regr2_6, cells(b(star fmt(3)) t(par fmt(2))) stats(r2_a, fmt(3) labels(R2_a))  style(tex) keep(length cyclomatic quantity potentialvolume operatordiversity level) starlevels(* 0.10 ** 0.05 *** 0.01) ///
legend label collabels(none)  type


// ONLINE APPENDIX. Correlation of different counts of operands and operators with time.
gen uniqueoperators = uniquemoperators+uniqueloperators+uniqueroperators
gen totaloperators = totalmoperators + totalloperators + totalroperators
gen uniquewords = uniqueoperands+uniqueoperators

quietly reg time length i.id_question i.user, robust
estimates store regr3_1
quietly reg time totaloperands totaloperators i.id_question i.user, robust 
estimates store regr3_2
quietly reg time uniquewords i.id_question i.user, robust 
estimates store regr3_3
quietly reg time uniqueoperands uniqueoperators i.id_question i.user, robust 
estimates store regr3_4 
quietly reg time length uniqueoperands uniqueoperators i.id_question i.user, robust 
estimates store regr3_5

// Table OA.16
estout regr3_1 regr3_2 regr3_3 regr3_4 regr3_5, cells(b(star fmt(3)) t(par fmt(2))) stats(r2_a, fmt(3) labels(R2_a))  style(tex) keep(length uniquewords totaloperands totaloperators uniqueoperands uniqueoperators) starlevels(* 0.10 ** 0.05 *** 0.01) ///
legend label collabels(none)  type


// ONLINE APPENDIX. Correlation of different measures with time, not controlling for length.

quietly reg time length i.id_question i.user, robust 
estimates store regr4_1
quietly reg time cyclomatic i.id_question i.user, robust 
estimates store regr4_2
quietly reg time quantity i.id_question i.user, robust 
estimates store regr4_3
quietly reg time potentialvolume i.id_question i.user, robust 
estimates store regr4_4
quietly reg time operatordiversity i.id_question i.user, robust 
estimates store regr4_5
quietly reg time level i.id_question i.user, robust 
estimates store regr4_6

// Table OA.17
estout regr4_1 regr4_2 regr4_3 regr4_4 regr4_5 regr4_6, cells(b(star fmt(3)) t(par fmt(2))) stats(r2_a, fmt(3) labels(R2_a))  style(tex) keep(length cyclomatic quantity potentialvolume operatordiversity level) starlevels(* 0.10 ** 0.05 *** 0.01) ///
legend label collabels(none)  type
