//Directory for Windows user:
//cd %systemdrive%\Users\%username%\Downloads\Codes\04_Experiments\
//Directory for MacOS user:
//cd ~/Downloads/04_Experiments/

use "Datasets/main.dta", replace


//Create a dataset with 38 regulations and time taken.

//Convert time into number of seconds
rename time time2
generate time = 60*mm(time2)+ss(time2)
drop time2

replace time = . if is_correct==0
replace time = . if time >= 579

collapse(mean) is_correct time length cyclomatic quantity potentialvolume operatordiversity level uniqueoperands uniquemoperators uniqueloperators uniqueroperators totaloperands totalmoperators totalloperators totalroperators, by(id_regulation)

//1. Correlation of different measures with time, controlling for length.

quietly reg time length, robust
estimates store regr3_1
quietly reg time length cyclomatic, robust
estimates store regr3_2
quietly reg time length quantity, robust
estimates store regr3_3
quietly reg time length potentialvolume, robust
estimates store regr3_4
quietly reg time length operatordiversity, robust
estimates store regr3_5
quietly reg time length level, robust
estimates store regr3_6

// Table OA.11
estout regr3_1 regr3_2 regr3_3 regr3_4 regr3_5 regr3_6, cells(b(star fmt(3)) t(par fmt(2))) stats(r2_a, fmt(3) labels(R2_a))  style(tex) keep(length cyclomatic quantity potentialvolume operatordiversity level) starlevels(* 0.10 ** 0.05 *** 0.01) ///
legend label collabels(none)  type
