(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     31963,        719]
NotebookOptionsPosition[     30514,        687]
NotebookOutlinePosition[     30914,        703]
CellTagsIndexPosition[     30871,        700]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"quantity", "[", "i_", "]"}], ":=", "i"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"potential", "[", "i_", "]"}], ":=", 
   RowBox[{
    RowBox[{"2", "i"}], "+", "3"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"muhat", "[", "i_", "]"}], ":=", 
   RowBox[{"1", "-", 
    RowBox[{"CDF", "[", 
     RowBox[{
      RowBox[{"NormalDistribution", "[", 
       RowBox[{"0", ",", "1"}], "]"}], ",", 
      RowBox[{
       RowBox[{"-", "2.872"}], "+", 
       RowBox[{"0.507", " ", 
        RowBox[{"quantity", "[", "i", "]"}]}]}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"effort", "[", "i_", "]"}], ":=", 
   RowBox[{"65.247", "+", 
    RowBox[{"7.965", 
     RowBox[{"potential", "[", "i", "]"}]}], "-", "63.485", "+", "2.293"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Lambda]", "=", "0.025"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Delta]", "=", "0.01"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p", "=", "0.05"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"w", "=", " ", "0.000001"}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"WelfareStar", "[", "i_", "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "\[Delta]"}], "/", "2"}], ")"}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Delta]", "/", 
       RowBox[{"(", 
        RowBox[{"2", " ", "i", " ", "\[Lambda]", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", "p"}], ")"}]}], ")"}]}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[Lambda]", 
        RowBox[{"(", 
         RowBox[{"1", "-", "p"}], ")"}]}], "-", "\[Delta]"}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Welfare0", ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "\[Lambda]"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}], "/", "6"}]}], ")"}], "-", 
    RowBox[{"(", 
     RowBox[{"\[Delta]", "/", "2"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TotalWelfare", "[", "i_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"muhat", "[", "i", "]"}], 
     RowBox[{"WelfareStar", "[", "i", "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"muhat", "[", "i", "]"}]}], ")"}], "Welfare0"}], "-", " ", 
    RowBox[{"w", " ", 
     RowBox[{"effort", "[", "i", "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.882448311890959*^9, 3.8824483180551805`*^9}, {
   3.8824487695075936`*^9, 3.882448810187643*^9}, {3.882448847814803*^9, 
   3.8824488689392004`*^9}, {3.8824489444213095`*^9, 3.88244895006249*^9}, {
   3.8824489962211432`*^9, 3.8824489976964254`*^9}, {3.8824491438280525`*^9, 
   3.8824491974433637`*^9}, 3.8824492332621174`*^9, {3.8824493050589*^9, 
   3.882449342007467*^9}, {3.8824493984393387`*^9, 3.88244941164614*^9}, {
   3.8824494754795947`*^9, 3.882449509120325*^9}, {3.8824495462703905`*^9, 
   3.8824495605251083`*^9}, {3.8824496037381477`*^9, 3.882449693474985*^9}, {
   3.8842529415365324`*^9, 3.8842529593902016`*^9}, {3.884253015995245*^9, 
   3.8842530686664042`*^9}, {3.8842532282821693`*^9, 
   3.8842532566364727`*^9}, {3.8842533299187393`*^9, 3.884253345172493*^9}, {
   3.8842533824240437`*^9, 3.884253415639763*^9}, {3.884253509235161*^9, 
   3.8842535093102283`*^9}, {3.884253561077041*^9, 3.884253561832013*^9}, 
   3.8842539826317153`*^9, {3.9368579856603494`*^9, 3.936858020875333*^9}, {
   3.9368580780776653`*^9, 3.9368581375005665`*^9}, {3.9368585755132523`*^9, 
   3.9368586050940437`*^9}, {3.9386722273015375`*^9, 3.938672239585489*^9}, {
   3.938672305696377*^9, 3.938672307579717*^9}, 3.9388342087811155`*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"e2d0776b-f93b-49f3-a963-022511a736f5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlotProba", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"muhat", "[", "i", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "2", ",", "10"}], "}"}], ",", " ", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<I\>\"", ",", 
       "\"\<\!\(\*OverscriptBox[\(\"\<\[Mu]\>\"\), \(^\)]\)(I)\>\""}], 
      "}"}]}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<Probability of correct implementation\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.840534598337508*^9, 3.840534608154304*^9}, {
  3.8405346808885365`*^9, 3.8405346831167774`*^9}, {3.840537128487359*^9, 
  3.8405371435642853`*^9}, {3.841231606283575*^9, 3.8412316307626977`*^9}, {
  3.8445042083462625`*^9, 3.844504243679224*^9}, {3.8824492148776712`*^9, 
  3.882449215322003*^9}, {3.882449387790095*^9, 3.8824493908107233`*^9}, {
  3.882449442075147*^9, 3.8824494452085724`*^9}, {3.9368581468252115`*^9, 
  3.9368581679995914`*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"f1f965b0-aa5a-4586-9204-72189fdcf31e"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVj3s01GkYxwe5l8tk3BVmWU6JLeqU8jxJyiUUmtY2VkpKNpcuOFEUNU5m
xmTGCjFWSVRMLlsxTJeJpLEuZVy6bOQSBrsahbK//eM9z/mcz/f5nue1CI3a
E6ZIIpH8iff/7BCNUoiB3KUVCa7fZMBR6Y9TUSbhTN+CSvqCDPy8JT1LNUjY
++i8ddu8DCTd964Z6ZGQFnnWJGhOBs9lZ6zW2ZCQE24rjZiVgchUy+mwHwkv
3X93Im5aBnfj1wa08glfFD3l/FEG6Q5nruRsVcCf3MIk4S9ksHrVDMWlQBEZ
dtbT4gwZDEDmWPOAEiqvGxREesjAi+s8N2WpjCavKzVp3yeAf0KibZ2kgo3b
o1v/KZoAtd9S41CkivSEhVkhTgB92mIofIU66pozN9e0jMOhGglz9WkNfLNF
rk33GIezWQWXXtdq4nXr1mXwdAzSFgIZTPIyVHlfdvWL1RgUnnPos6VpYXMl
TTaf+gmOuRqHH+Rpo4JnRVNz7yjoNn9eCIjTwVPb6mjxeqMwOx81GWGoi4dO
XuAo+o6A/2d6mGqTLu5kiNsMI4eBweqMi40l48mTxc2OKUPQVB20zo+8HI8/
ZPv65X+ERH5gbHXjcvQZx7FruYPgbBQadPmAHtYIsty5fwxANO2DeESHgtz0
rqO+7A9w1unTSz0hBU/Y7lXzTfwbsvlK56ro+hhbbmnhkvAefmjPrJJqGmCJ
q/Jnw8a3UM+y50TfNcB7px2FVlX9YDceqNm9yxAdc1gqDbW9oKc9pfZ0zhAN
tRR33s6RgnJjXgU13wiXDFwyHyp7DZGOdT3qXsZYesVcx/l6F9z2COU3yI3R
OF6fWfewA+RjxjpD2SZo08IXmqi0Q63/DiWumyl+Wb/FXSldAsk70wqrhwh2
rhfcjHkBlm88pcVpZhjtaTBkdrUZnDekco3WrkCk8JmmD8RAX9H2VaFzBSZ7
3S3a7/IE5C3MD9EpK5G0fXpY/kwE3or2m2zJ5kiKDaj/9osQNCaDdiuEmmMm
8DiHCh/AhQYsy79vjsgj05u+1kBKQAUtRt0CpxLzLpZO3oNNL7vd1Q9YYCa9
asFjSSW8o7ilqv1pgaLQ/fZ2iuWgbrVRf6uqJercEYfVDpeATH9kdHOwJZK0
BauXahTDvraV5NgKSwzJf+Vj21cIFbQ8htYi4au7vYdzcuHR47/weCAV33Pm
jkjqeMCoU7pRuZeKyQ1+pWvKeeBTvV79XxrBYfyyq7k86L2R3x4XREXR42UD
7AQezDCOhKb8SkUM4bAXNvDA2peUyj1K9On1uHTUciGjz77pYRLhG1pOedZn
wb4Z1i7VEiqSzNrSfD5y4JnE1SHqJuHFPuKsVxxwvCUnd5cS/dI7XYNiDmgH
B0tLyom+7+d3lJUQ+Sa7g+4CYl/mJ3x0hANOea3xafUEx0/JTCczgeyqcV2p
k4ohIpZG4JJMSDZtuHisi+hLiXfUGmeDTB5ztPMVkU/ibWO0seF5ec+aYinx
P3u3BWE2G5Iptx64viXyPwoPr7Fmw+TIjraUUeK+31NuGXiwYP+TecHoJ2J/
N6mgy44FLdcquLvHCW+3XFBCZkHJHoMgi0miz817Mb2fCcH1Q4OiGYKLYju9
YpjQmp3bZCMn8olS/8q9TNgU41OWOUuwzdxl281MoFjXRoXMEXmF4KmfVZlw
nhSxp3me4CRLJd2JDJjqNXNy+EbkI27m9ndkQHBNu0HOd8LXbyyrv58Brey0
ucVF4j7qKitBQQb8B48kYdo=
       "]]},
     Annotation[#, "Charting`Private`Tag$20276#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox["\"I\"", HoldForm], TraditionalForm], 
    FormBox[
     TagBox[
     "\"\\!\\(\\*OverscriptBox[\\(\\\"\[Mu]\\\"\\), \\(^\\)]\\)(I)\"", 
      HoldForm], TraditionalForm]},
  AxesOrigin->{2.0000000000000044`, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotLabel->FormBox[
   "\"Probability of correct implementation\"", TraditionalForm],
  PlotRange->{{2, 10}, {0., 0.9684154869686545}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.84053460984807*^9, 3.840534645829953*^9, 3.8405347074683046`*^9, {
   3.840537129205352*^9, 3.840537143800974*^9}, {3.841231617206256*^9, 
   3.8412316329082985`*^9}, 3.8412317551611924`*^9, {3.844504211108173*^9, 
   3.844504244390373*^9}, 3.8824492350980473`*^9, {3.8824493881432643`*^9, 
   3.882449445697196*^9}, 3.882449510489155*^9, 3.8830411163423862`*^9, 
   3.8842530733190603`*^9, 3.8842535734713163`*^9, {3.9368581532002296`*^9, 
   3.9368581685866556`*^9}, 3.9386722804328995`*^9, 3.938672311101365*^9, 
   3.938834213335431*^9, 3.938834369475314*^9, 3.953023461841407*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"c6b7db6a-06c4-4441-a811-79c4e566e0a0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlotEffort", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"effort", "[", "i", "]"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "2", ",", "10"}], "}"}], ",", " ", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<I\>\"", ",", 
       "\"\<\!\(\*TemplateBox[{\"e\", \
\"\\\"*\\\"\"},\"Superscript\"]\)(I)\>\""}], "}"}]}], ",", 
    RowBox[{"PlotLabel", "\[Rule]", "\"\<Effort\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.840534925627616*^9, 3.840534954750398*^9}, {
   3.840537147663426*^9, 3.840537147773008*^9}, {3.8412313260042458`*^9, 
   3.8412313390227222`*^9}, 3.841231538790188*^9, {3.8412316372178173`*^9, 
   3.8412316391212187`*^9}, {3.844504364797037*^9, 3.844504364931398*^9}, {
   3.882449258834921*^9, 3.8824492591666627`*^9}, 3.8824494508114047`*^9, {
   3.8830411246402807`*^9, 3.883041125300253*^9}, {3.9368581750138283`*^9, 
   3.9368582019197907`*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"e9632e72-0046-4626-96f3-38ccf4546dad"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVjHk01AkAxwe5yzAZ17rGD5syUdKB9OWhVobBTCSGmWF+bVnjKGyHoyjV
U2o1WyGzm1XJmpy1NaHTVIxKhdXqpZ51hd6KwrL2j8/7/PN5H4ZAHBKnSqFQ
WAv87xfNg/QFgWkcsLzqbxZOa7xJ01CnYENjxnDVCAvsAGX3Yh0KvOKqK2Wf
WFB21pSYGlIQVmvkVD3DwuPR/XYuyyjIDnrnUkcNRLO5nquITUHH0dSNt9YF
oip9NadVSsGPX6TsR0cDccx5/5lzXiq43/05tffbIDiumKB7XlTFs/pNTRle
bLzfVDCseK8GSkrgm/z3bGwtdJ8et1FH4V6eg/hQMKQpSqr9QQ20Rvd2tKwM
gdYPOWlo1oSf5xVjaXsIoj4x+klLbcQu6rs5djAUsfXKfMdUHXygWhw3cOAg
46eLR1836OIK9deJGgUHubPcvHzaEuhPSeRP93JRmunc4xCmB/mLVxaxxtuw
29uMFJ6lQvEPXaas3wYDxedZTpo+0mcfllznh2FqRjy2y8QA8V+b7Giq4Qj9
HBWn2WIA1V4H3WFZOPJOdqQlJ9Mwq3nWWhKxHS11ES5s2lKst/dvb/66HQek
3OS6pqUwcxT3CMoj4G4qiDjBN4SHfW9WzuYdSAzrezigT8cirTuHLSZ3IMN1
qM3wDh2OTiUNeb9EQiJVy6yNMsIF/5ZDKV5RsH1eUNula4wKFr/y1WgU5Ced
TidWGWPWx1d8o4AH5ghXt5Nlgrrs5YLdTtEwpI5rPZg2weLyzBpJTzTUm4pk
RLEpONFUpbVnDOLX3O7W3mqGPW8ln1adjUHldwJp46QZ/FStmJVDMZgcNtPv
l3wDN6sAV5EbHw2hm9UKfcwx57RqpKeAj6wtuaV1/eb44HZbfPodHzZ/+Xdd
yrXAgQFf3evOArivyyk0XW2J/mN53ONHBIiybP+q0mGJBLvE+LLXAkw+ye9L
zLZCax119T6mEAGqTm4ONGv4e3IenMoQQmcsIlhFYI30XecT9JRCHG5ERfFN
a+w7LmnZYhuLbI4sLEmbgeKy9R/v7YmFW1unnzafgTM1Z+5+eRqLt3SfHK0b
DKwVfvz9Z0YctO02GHlp2mBuyUdRalIcRo0GBj14NpBUlin1FXEIb7eiJcts
wPZVURs2EUEWVpSnN2+Dxixe0MqdIty99wwJXALTshR/ZqMI4RMnWZrlBCK6
mbR4PRKPlN7O4ssEmtnt/BdUEmuuTtI6rxCwVSRWrzcgQeXxusqvERhpqGWr
Gy70LUyhXzWBrMINpy6aknAtak3PlRMoD/Jd/NyWBM1bp0ytg8D4w0iNte4k
sswbj+x+SWDbxjlusQeJ0cmk7zteEbhVV/qbqieJx9e6V17qIpBzqc+nHQs9
/eof3r0EjLJ3Ht7pR2JsYHN79iABD489lKJgEpH3Z6oHhwhIa+lslVAST0pk
hcEjBBatuFFKckiUhxhHMMYIKE2nPdeEkeDJ+z80TxAQTGUebIsk0Sq50LJs
ksCjBEabC4+EW1JgRcEUAcf+e+YXoknQ7RvEMdMEJl6qy0UCEocou0IUMwTC
Ay7rtglJjP9p4er8LwH5/S07XOIW/vXPjc/NEbBxH6o4L1r4n8qdnp8ncKTm
xPQ8SeI/Kp4Vag==
       "]]},
     Annotation[#, "Charting`Private`Tag$20932#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox["\"I\"", HoldForm], TraditionalForm], 
    FormBox[
     TagBox[
     "\"\\!\\(\\*TemplateBox[{\\\"e\\\", \
\\\"\\\\\\\"*\\\\\\\"\\\"},\\\"Superscript\\\"]\\)(I)\"", HoldForm], 
     TraditionalForm]},
  AxesOrigin->{2.0000000000000044`, 59.81000260081646},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotLabel->FormBox["\"Effort\"", TraditionalForm],
  PlotRange->{{2, 10}, {59.810002600816325`, 187.24999739918366`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.8405349354330287`*^9, 3.8405349549913216`*^9}, 
   3.8405371480070925`*^9, 3.8412313407255244`*^9, 3.841231540022129*^9, 
   3.841231639832719*^9, 3.8412317626978827`*^9, {3.844504362146185*^9, 
   3.84450436518546*^9}, 3.8824492603898067`*^9, 3.882449451278226*^9, {
   3.8830411188082933`*^9, 3.8830411266755223`*^9}, 3.8842535755214844`*^9, 
   3.936858207279807*^9, 3.9386722829785247`*^9, 3.9386723133924084`*^9, 
   3.9388342152731915`*^9, 3.9388343702984085`*^9, 3.9530234735776176`*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"cda05469-9745-45d3-811b-0b5335c46089"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlotWelfareSimple", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"WelfareStar", "[", "i", "]"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "2", ",", "10"}], "}"}], ",", " ", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<I\>\"", ",", 
       "\"\<\!\(\*TemplateBox[{\"W\", \
\"\\\"*\\\"\"},\"Superscript\"]\)(I)\>\""}], "}"}]}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<Expected Welfare - Without complexity costs\>\""}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.8405374140415335`*^9, 3.840537469984993*^9}, {
   3.841231135318252*^9, 3.84123115253778*^9}, {3.8412312012628307`*^9, 
   3.8412312471099524`*^9}, {3.84123135263595*^9, 3.841231354299715*^9}, {
   3.8412316461961565`*^9, 3.8412316481889653`*^9}, {3.8445043917048893`*^9, 
   3.8445043919192734`*^9}, 3.8824492773073483`*^9, 3.882449454130881*^9, {
   3.8830411533290043`*^9, 3.8830411629523277`*^9}, {3.8830411943986444`*^9, 
   3.8830411960988436`*^9}, {3.9368582210080643`*^9, 3.936858244871377*^9}, {
   3.93685828199087*^9, 3.936858344519675*^9}, 3.938672321437606*^9},
 CellLabel->"In[14]:=",ExpressionUUID->"7b89d3b8-f13c-41ff-9cf1-e64855e140a2"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV0Hs0lAkUAPBBCGWmyZjxSM18KyohZXtvl9KDshJN6zCnET30EPb75kFp
Cqs6xLI2EdPa1TJleijbkKvWq2gk7ZpWWys1i1qjXVGjsl9/3HPP75z7OPfy
o+NDY00ZDMYmOj7lBw0DHDpByCEHyN4tx1yLxxILcwbw+K4+V3bKMWSj9tEU
awasNMiCu2PkqO2+ctbBjgGXxEoTV7Ec7wwluy50Z8BFp4KF2q/k2OBs67sz
hAEvxN66rUFyrJL6hLUrGWC7Rj+21EuOx72Tvz3tZwIb+riObKMMPeaNcL4o
MYVtPbfaBHky7FuV87K1zwyqFleew1UyDMpfbhwWmIP9ndHmujEpKpO0zNmH
LIBSxp8qvyLFyfvTJNBgCV5OgYUBMilGvebrd7lYge1rTkahnxRjrmmzPChr
UFBZF06wpHg4r+Sb36/bQGpOiZH1twTT34dnZrGnwj0T40l+vQRLU7175ght
gZWW4be0SIJ7/R137fiOCYGqvoAbyRKc1vrmfZiEBVkpxbErIiU4Nh5viONN
g3l5KRKenwS3vImKtWyZBjGME5d0rhLMzO6SJCayobn3i9W2UyXYUh2xMIQ9
HZ4+v0koxihMUYYnVuN0GNzxuErVS+Fyh+iIk2I7yHjIe1CopfCg8FlTP4sD
b731N5bVUnjYd/Ce3U0OlLGijbEVFBYozVKvRtlD0sXV5rWFFH7WmXNVZ8OF
Z6KzzGvHKazL9so9WMUFUc2K4bxkCue/Crfp3sSDJYFxUQkHKLRjDk9uNPLg
3+fnbQzbKTTHIjVR7ADnNPdD3oZRuG9R7SOrIEcweBhrytdTeGFDtLJ+1BEC
E13c5q6kcPSlI0tf4ARbd0cGjfhQeH3LOrP8Nc6QyBtOinGn8Mj69NJqvTNc
TbM2G3ehUPBnoK4sfQboCacoV3v63sVp+Q4+LiBuMiXfTqEwyqXjnUmXC7Rm
jMmaJtHz72Y9O6iYCaeXvKqE9yRuNPVaNoc9C5I1no2lIyRaGyI2m0TPguiP
55oP/EPisXqoLP5lFvBPCRWGFyQqwtTCBCs+5A/8x/B9SuKye91rrcR8OKMJ
mbpAR+JTzpq0yTV8YG/12JLbSaKV61J7P0sBdARspIrbSByy7x9YIRLA4975
OnETids6ZrIT1QJ4UmJCNSGJamFRpu2EAGQ9bb1JGhJv3b4PB8IJ+Dy93POv
arp+JHuTZTkBK3WTPHVqEpu1/t7x5wno2p9jd5v2oopRdvfPBHBnBHxU0WaK
RLpyFQGNbLee1E/1LfN3rL1MwIZ9Go0bbd+idml6HQEpFpksaRWJbH/rH826
CNgTymY7XSTxiHN9xt6HBJA/fB1pTntoNGFP128ErNUMVhgukHhH9cizTEfA
92XM4EbaRzgVN/yfEDDCnVu7n7ahf12HYoCABUam+y0ViZG/jl8eGCTghHp7
mYr23bPq/M2vCDjWpuEX0C4P5UbwDQTs+ynTbS9tUZ3+ecMIAdZDUiGHdnvB
mRb3UQI+9Jm+nKik/58QXJkzRoCMn6sYpM2ZfT1+u5GAYX1NDdI+yogLbR0n
IHjOl8JK2sN/zPD1/kD3u/W/y6ctutbJPf2RACUcLU2l3X4q3TgxQe/rdF4f
R/t/9+NLvQ==
       "]]},
     Annotation[#, "Charting`Private`Tag$21404#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox["\"I\"", HoldForm], TraditionalForm], 
    FormBox[
     TagBox[
     "\"\\!\\(\\*TemplateBox[{\\\"W\\\", \
\\\"\\\\\\\"*\\\\\\\"\\\"},\\\"Superscript\\\"]\\)(I)\"", HoldForm], 
     TraditionalForm]},
  AxesOrigin->{2.0000000000000044`, -0.005225146210383112},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotLabel->FormBox[
   "\"Expected Welfare - Without complexity costs\"", TraditionalForm],
  PlotRange->{{2, 10}, {-0.006447368302900117, -0.005289473688936628}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.936858336692175*^9, 3.9368583450442724`*^9}, 
   3.9386722852117414`*^9, {3.938672315338891*^9, 3.9386723219213624`*^9}, 
   3.938834216991456*^9, 3.93883437222536*^9, 3.9530234777334223`*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"233247e0-0532-443c-97b5-4948cf880f90"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PlotTotal", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"TotalWelfare", "[", "i", "]"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "2", ",", "10"}], "}"}], ",", " ", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<I\>\"", ",", "\"\<\>\""}], "}"}]}], ",", 
    RowBox[{
    "PlotLabel", "\[Rule]", 
     "\"\<Expected Welfare - With complexity costs\>\""}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.882449350616569*^9, 3.882449377399057*^9}, {
   3.882449422960622*^9, 3.882449423058478*^9}, 3.882449457662298*^9, {
   3.883041172479457*^9, 3.8830411904650683`*^9}, {3.9368583508458157`*^9, 
   3.936858364752921*^9}, 3.936858645792345*^9},
 CellLabel->"In[15]:=",ExpressionUUID->"439d1310-5729-4a15-9f77-191d68b7137b"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV13k4VVsbAHDTcfY5B2WmkM4pV4okUoiXDGVKIUMopEmmcquzyXBCw70y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       "]]},
     Annotation[#, "Charting`Private`Tag$21876#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox["\"I\"", HoldForm], TraditionalForm], 
    FormBox[
     TagBox["\"\"", HoldForm], TraditionalForm]},
  AxesOrigin->{2.0000000000000044`, -0.006148653426143636},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotLabel->FormBox[
   "\"Expected Welfare - With complexity costs\"", TraditionalForm],
  PlotRange->{{2, 10}, {-0.009094312646474784, -0.006303688121950524}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.8824493556155753`*^9, 3.882449377666244*^9}, {
   3.8824494191179886`*^9, 3.882449423339405*^9}, 3.882449458145813*^9, {
   3.8824495046049657`*^9, 3.8824495141689887`*^9}, {3.8824495535698433`*^9, 
   3.8824495646733475`*^9}, {3.882449612051611*^9, 3.8824496874123516`*^9}, {
   3.8830411774056587`*^9, 3.88304119910443*^9}, 3.8842535823592362`*^9, {
   3.936858361987484*^9, 3.9368583649382315`*^9}, {3.9368585812959433`*^9, 
   3.936858608144211*^9}, 3.936858647854785*^9, 3.938672325545602*^9, 
   3.938834219143516*^9, 3.9388343743129387`*^9, 3.953023483109039*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"48aea528-aec8-4a4d-aa6e-ef2c4877f8b7"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"SetDirectory", "[", 
  RowBox[{"NotebookDirectory", "[", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.938834427792494*^9, 3.93883442779351*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"648a949e-61dc-4243-a3cd-e61293bc69a9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<TimeI.pdf\>\"", ",", "PlotEffort"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<ProbaI.pdf\>\"", ",", "PlotProba"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<Welfare0I.pdf\>\"", ",", "PlotWelfareSimple"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<WelfareI.pdf\>\"", ",", "PlotTotal"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8412316833082867`*^9, 3.8412317250919433`*^9}, 
   3.88304194020358*^9, {3.9368583790660152`*^9, 3.9368583823429165`*^9}, {
   3.938834225044156*^9, 3.938834225229066*^9}, {3.93883432085953*^9, 
   3.938834338745865*^9}, {3.938834378364086*^9, 3.9388343800981803`*^9}, 
   3.938834430685214*^9},
 CellLabel->"In[21]:=",ExpressionUUID->"18723ae7-ba9c-4921-9002-9218a8dad311"]
},
WindowSize->{949, 467},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"13.2 pour Microsoft Windows (64-bit) (January 30, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"64e6ba4f-83b3-4abf-9a51-6c483bdc77df"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 3911, 101, 273, "Input",ExpressionUUID->"e2d0776b-f93b-49f3-a963-022511a736f5"],
Cell[CellGroupData[{
Cell[4494, 125, 1057, 23, 48, "Input",ExpressionUUID->"f1f965b0-aa5a-4586-9204-72189fdcf31e"],
Cell[5554, 150, 4395, 93, 264, "Output",ExpressionUUID->"c6b7db6a-06c4-4441-a811-79c4e566e0a0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9986, 248, 1052, 22, 47, "Input",ExpressionUUID->"e9632e72-0046-4626-96f3-38ccf4546dad"],
Cell[11041, 272, 4200, 89, 260, "Output",ExpressionUUID->"cda05469-9745-45d3-811b-0b5335c46089"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15278, 366, 1239, 26, 85, "Input",ExpressionUUID->"7b89d3b8-f13c-41ff-9cf1-e64855e140a2"],
Cell[16520, 394, 3943, 86, 246, "Output",ExpressionUUID->"233247e0-0532-443c-97b5-4948cf880f90"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20500, 485, 813, 18, 78, "Input",ExpressionUUID->"439d1310-5729-4a15-9f77-191d68b7137b"],
Cell[21316, 505, 8000, 150, 266, "Output",ExpressionUUID->"48aea528-aec8-4a4d-aa6e-ef2c4877f8b7"]
}, Open  ]],
Cell[29331, 658, 248, 4, 43, "Input",ExpressionUUID->"648a949e-61dc-4243-a3cd-e61293bc69a9"],
Cell[29582, 664, 928, 21, 149, "Input",ExpressionUUID->"18723ae7-ba9c-4921-9002-9218a8dad311"]
}
]
*)

