//Directory for Windows user:
//cd %systemdrive%\Users\%username%\Downloads\Codes\04_Experiments\
//Directory for MacOS user:
//cd ~/Downloads/04_Experiments/

use "Datasets/main.dta", replace

gen mistake = 1-is_correct

//1. Correlation of different measures with mistake, controlling for length.

quietly probit mistake length i.id_question i.user, robust 
estimates store regr1_1
quietly probit mistake length cyclomatic i.id_question i.user, robust 
estimates store regr1_2
quietly probit mistake length quantity i.id_question i.user, robust 
estimates store regr1_3
quietly probit mistake length potentialvolume i.id_question i.user, robust 
estimates store regr1_4
quietly probit mistake length operatordiversity i.id_question i.user, robust 
estimates store regr1_5
quietly probit mistake length level i.id_question i.user, robust 
estimates store regr1_6

//Table 5
estout regr1_1 regr1_2 regr1_3 regr1_4 regr1_5 regr1_6, cells(b(star fmt(3)) t(par fmt(2))) stats(r2_p, fmt(3) labels(Pseudo-R2))  style(tex) keep(length cyclomatic quantity potentialvolume operatordiversity level) starlevels(* 0.10 ** 0.05 *** 0.01) ///
legend label collabels(none)  type


// ONLINE APPENDIX. Correlation of different measures with mistake, controlling for length. No round fixed effects.

quietly probit mistake length i.user, robust 
estimates store regr2_1
quietly probit mistake length cyclomatic i.user, robust 
estimates store regr2_2
quietly probit mistake length quantity i.user, robust 
estimates store regr2_3
quietly probit mistake length potentialvolume i.user, robust 
estimates store regr2_4
quietly probit mistake length operatordiversity i.user, robust 
estimates store regr2_5
quietly probit mistake length level i.user, robust 
estimates store regr2_6

// Table OA.12
estout regr2_1 regr2_2 regr2_3 regr2_4 regr2_5 regr2_6, cells(b(star fmt(3)) t(par fmt(2))) stats(r2_p, fmt(3) labels(Pseudo-R2))  style(tex) keep(length cyclomatic quantity potentialvolume operatordiversity level) starlevels(* 0.10 ** 0.05 *** 0.01) ///
legend label collabels(none)  type


// ONLINE APPENDIX. Correlation of different counts of operands and operators with mistake.

gen uniqueoperators = uniquemoperators+uniqueloperators+uniqueroperators
gen totaloperators = totalmoperators + totalloperators + totalroperators
gen uniquewords = uniqueoperands+uniqueoperators

quietly probit mistake length i.id_question i.user, robust
estimates store regr3_1
quietly probit mistake totaloperands totaloperators i.id_question i.user, robust
estimates store regr3_2
quietly probit mistake uniquewords i.id_question i.user, robust 
estimates store regr3_3
quietly probit mistake uniqueoperands uniqueoperators i.id_question i.user, robust 
estimates store regr3_4
quietly probit mistake length uniqueoperands uniqueoperators i.id_question i.user, robust 
estimates store regr3_5

// Table OA.13
estout regr3_1 regr3_2 regr3_3 regr3_4 regr3_5, cells(b(star fmt(3)) t(par fmt(2))) stats(r2_p, fmt(3) labels(Pseudo-R2))  style(tex) keep(length uniquewords totaloperands totaloperators uniqueoperands uniqueoperators) starlevels(* 0.10 ** 0.05 *** 0.01) ///
legend label collabels(none)  type


// ONLINE APPENDIX. Correlation of different measures with mistake, not controlling for length.

quietly probit mistake length i.id_question i.user, robust 
estimates store regr4_1
quietly probit mistake cyclomatic i.id_question i.user, robust 
estimates store regr4_2
quietly probit mistake quantity i.id_question i.user, robust 
estimates store regr4_3
quietly probit mistake potentialvolume i.id_question i.user, robust 
estimates store regr4_4
quietly probit mistake operatordiversity i.id_question i.user, robust 
estimates store regr4_5
quietly probit mistake level i.id_question i.user, robust 
estimates store regr4_6

// Table OA.14
estout regr4_1 regr4_2 regr4_3 regr4_4 regr4_5 regr4_6, cells(b(star fmt(3)) t(par fmt(2))) stats(r2_p, fmt(3) labels(Pseudo-R2))  style(tex) keep(length cyclomatic quantity potentialvolume operatordiversity level) starlevels(* 0.10 ** 0.05 *** 0.01) ///
legend label collabels(none)  type


// ONLINE APPENDIX. Correlation of different measures with mistake, controlling for length. Linear probability model.

quietly reg mistake length i.id_question i.user, robust 
estimates store regr5_1
quietly reg mistake length cyclomatic i.id_question i.user, robust 
estimates store regr5_2
quietly reg mistake length quantity i.id_question i.user, robust 
estimates store regr5_3
quietly reg mistake length potentialvolume i.id_question i.user, robust 
estimates store regr5_4
quietly reg mistake length operatordiversity i.id_question i.user, robust 
estimates store regr5_5
quietly reg mistake length level i.id_question i.user, robust 
estimates store regr5_6

// Table OA.18
estout regr5_1 regr5_2 regr5_3 regr5_4 regr5_5 regr5_6, cells(b(star fmt(3)) t(par fmt(2))) stats(r2_a, fmt(3) labels(Adjusted-R2))  style(tex) keep(length cyclomatic quantity potentialvolume operatordiversity level) starlevels(* 0.10 ** 0.05 *** 0.01) ///
legend label collabels(none)  type
